using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using MethodBase = System.Reflection.MethodBase;
using gov.va.med.vbecs.ExceptionManagement;
using CANNEDCOMMENT = gov.va.med.vbecs.Common.VbecsTables.CannedComment;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{	
		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/5/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data Access component providing database read/write functionality for 'canned comments' data.
	///</summary>

		#endregion

	public class CannedComment
	{
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="850"> 
		///		<ExpectedInput>Valid division code</ExpectedInput>
		///		<ExpectedOutput>Data table containing canned comments</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1846"> 
		///		<ExpectedInput>Invalid Division</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns canned comments of all category types for a given division
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <returns>DataTable containing canned comments</returns>
		public static DataTable GetCannedComments(string divisionCode)//, bool returnCannedCommentID)
		{
			SqlParameter _prm = new SqlParameter( STOREDPROC.GetCannedComments.divisioncode, System.Data.SqlDbType.Char );
			_prm.Value = divisionCode;		
			
			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetCannedComments.StoredProcName, _prm );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="851"> 
		///		<ExpectedInput>Division code and canned comment category</ExpectedInput>
		///		<ExpectedOutput>Data table containing canned comments</ExpectedOutput>
		///	</Case>
		///<Case type="1" testid ="1847"> 
		///		<ExpectedInput>Invalid Division/Category</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns canned comments of a specified category type for a given division
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <param name="category">Canned comment category type</param>
		/// <returns>DataTable containing canned comments</returns>
		public static DataTable GetCannedComments(string divisionCode, string category)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetCannedComments.divisioncode, System.Data.SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetCannedComments.cannedcommentcategorycode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = divisionCode;
			prms[1].Value = category;
			
			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetCannedComments.StoredProcName, prms );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2065"> 
		///		<ExpectedInput>CannedComment Guid</ExpectedInput>
		///		<ExpectedOutput>Data table</ExpectedOutput>
		///	</Case>
		///<Case type="1" testid ="2066"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets a Canned COmment using Guid
		/// </summary>
		/// <param name="cannedCommentGuid"></param>
		/// <returns></returns>
		public static DataTable GetCannedComment(Guid cannedCommentGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetCannedComment.cannedcommentguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetCannedComment.divisioncode , System.Data.SqlDbType.Char)
			};

			prms[0].Value = cannedCommentGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			return Common.StoredProcedure.GetDataTable(STOREDPROC.GetCannedComment.StoredProcName, prms );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1841"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of CannedCommentCategories</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1100"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns canned comment category types
		/// </summary>
		/// <returns>DataTable containing canned comment categories</returns>
		public static DataTable GetCannedCommentCategories()
		{
			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetCannedCommentCategories.StoredProcName );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="852"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1848"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Saves changes to a table of canned comments to the database and returns success indicator.
		/// </summary>
		/// <param name="sprocArrayList">List of stored procedures to use</param>
		/// <param name="dtArrayList">ArrayList of DataTables containing canned comment data</param>
		/// <returns>True on success. Otherwise - false.</returns>
		public static bool Save( ArrayList sprocArrayList, ArrayList dtArrayList )
		{
			return ( new StoredProcedure().TransactionalGetValue( sprocArrayList, dtArrayList ) == 0 );
		}			


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/11/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7530"> 
		///		<ExpectedInput>true</ExpectedInput>
		///		<ExpectedOutput>DataTable with RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7531"> 
		///		<ExpectedInput>false</ExpectedInput>
		///		<ExpectedOutput>DataTable without RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// spInsertCannedComment, spUpdateCannedComment
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static System.Data.DataTable GetEmptyCannedCommentTableSchema(bool isUpdate)
		{
			DataTable dtComment = new System.Data.DataTable(CANNEDCOMMENT.TableName);

			dtComment.Columns.Add(CANNEDCOMMENT.CannedCommentGuid, typeof(System.Guid));
			dtComment.Columns.Add(CANNEDCOMMENT.SortColumn, typeof(int));
			dtComment.Columns.Add(CANNEDCOMMENT.LastUpdateFunctionId, typeof(int));
			dtComment.Columns.Add(CANNEDCOMMENT.RecordStatusCode, typeof(string));

			if (isUpdate)
			{
				dtComment.Columns.Add(CANNEDCOMMENT.RowVersion , typeof(byte[]));
			}
			else
			{
				dtComment.Columns.Add(CANNEDCOMMENT.CannedCommentCategoryCode, typeof(string));
				dtComment.Columns.Add(CANNEDCOMMENT.CannedCommentText , typeof(string));
				dtComment.Columns.Add(CANNEDCOMMENT.DivisionCode , typeof(string));
			}

			return dtComment;
		}


	}
}

